/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.CommanderUtilsFile;
import org.luwrain.popups.PopupClosingTranslator;
import org.luwrain.popups.Popups;

public class CommanderPopup
extends CommanderArea<File>
implements CommanderArea.ClickHandler<File>,
Popup,
PopupClosingTranslator.Provider {
    public static final CommanderArea.Filter<File> FILTER_ALL = new CommanderUtils.AllEntriesFilter<File>();
    public static final CommanderArea.Filter<File> FILTER_NO_HIDDEN = new CommanderUtilsFile.Filter(EnumSet.of(CommanderUtilsFile.Filter.Flags.NO_HIDDEN));
    protected final PopupClosingTranslator closing = new PopupClosingTranslator(this);
    protected final Luwrain luwrain;
    protected final String name;
    protected final CommanderArea.Filter<File> filter;
    protected final Set<Popup.Flags> popupFlags;
    protected boolean filterCancelled;

    public CommanderPopup(Luwrain luwrain, String name, File file, CommanderArea.Filter<File> filter, Set<Popup.Flags> popupFlags) {
        super(CommanderPopup.newParams(luwrain, filter != null ? filter : FILTER_ALL));
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        this.luwrain = luwrain;
        this.name = name;
        this.popupFlags = popupFlags;
        this.filter = filter != null ? filter : FILTER_ALL;
        this.filterCancelled = this.filter == FILTER_ALL;
        this.setClickHandler(this);
        this.open(file, null, false);
    }

    @Override
    public CommanderArea.ClickHandler.Result onCommanderClick(CommanderArea area, File file, boolean dir) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)file, (String)"file");
        if (dir) {
            return CommanderArea.ClickHandler.Result.OPEN_DIR;
        }
        return this.closing.doOk() ? CommanderArea.ClickHandler.Result.OK : CommanderArea.ClickHandler.Result.REJECTED;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case INTRODUCE: {
                this.luwrain.speak(this.getAreaName(), Sounds.POPUP);
                return true;
            }
            case ACTION: {
                if (ActionEvent.isAction(event, "mkdir")) {
                    return Popups.mkdir(this.luwrain, (File)this.opened());
                }
                if (ActionEvent.isAction(event, "cancel-filter")) {
                    this.setCommanderFilter(FILTER_ALL);
                    this.filterCancelled = true;
                    this.reread(true);
                    return true;
                }
                if (ActionEvent.isAction(event, "change-disk")) {
                    File f = Popups.disks(this.luwrain, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0441\u043a:");
                    if (f == null) {
                        return false;
                    }
                    this.open(f, null, false);
                    return true;
                }
                return false;
            }
        }
        if (this.closing.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public String getAreaName() {
        return this.name + super.getAreaName();
    }

    @Override
    public boolean onOk() {
        return true;
    }

    @Override
    public boolean onCancel() {
        return true;
    }

    @Override
    public Action[] getAreaActions() {
        ArrayList<Action> res = new ArrayList<Action>();
        res.add(new Action("mkdir", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433", new InputEvent(InputEvent.Special.INSERT)));
        res.add(new Action("change-disk", "\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0438\u0441\u043a", new InputEvent(InputEvent.Special.TAB)));
        if (!this.filterCancelled) {
            res.add(new Action("cancel-filter", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u0444\u0430\u0439\u043b\u044b", new InputEvent(InputEvent.Special.F5)));
        }
        return res.toArray(new Action[res.size()]);
    }

    @Override
    public Luwrain getLuwrainObject() {
        return this.luwrain;
    }

    @Override
    public boolean isPopupActive() {
        return this.closing.continueEventLoop();
    }

    @Override
    public Set<Popup.Flags> getPopupFlags() {
        return this.popupFlags;
    }

    public boolean isCancelled() {
        return this.closing.cancelled();
    }

    private static CommanderArea.Params<File> newParams(Luwrain luwrain, CommanderArea.Filter<File> filter) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull(filter, (String)"filter");
        CommanderArea.Params<File> params = CommanderUtilsFile.createParams(new DefaultControlContext(luwrain));
        params.filter = filter;
        params.comparator = new CommanderUtils.ByNameComparator();
        return params;
    }
}

