/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.popups.EditListPopup;

public final class EditListPopupUtils {

    public static class FixedModel
    extends DynamicModel {
        protected final EditListPopup.Item[] fixedItems;

        public FixedModel(String[] items) {
            NullCheck.notNullItems((Object[])items, (String)"items");
            ArrayList<DefaultItem> v = new ArrayList<DefaultItem>();
            for (String s : items) {
                if (s.isEmpty()) continue;
                v.add(new DefaultItem(s));
            }
            this.fixedItems = v.toArray(new EditListPopup.Item[v.size()]);
            Arrays.sort(this.fixedItems);
        }

        @Override
        protected EditListPopup.Item[] getItems(String context) {
            return (EditListPopup.Item[])this.fixedItems.clone();
        }

        @Override
        protected EditListPopup.Item getEmptyItem(String context) {
            return new DefaultItem();
        }
    }

    public static abstract class DynamicModel
    implements EditListPopup.Model {
        protected abstract EditListPopup.Item[] getItems(String var1);

        protected abstract EditListPopup.Item getEmptyItem(String var1);

        @Override
        public String getCompletion(String beginning) {
            if (beginning == null) {
                return "";
            }
            EditListPopup.Item[] fullItems = this.getItems(beginning);
            if (fullItems == null || fullItems.length < 1) {
                return "";
            }
            String[] items = new String[fullItems.length];
            for (int i = 0; i < fullItems.length; ++i) {
                items[i] = fullItems[i].getValue();
            }
            ArrayList<String> m = new ArrayList<String>();
            for (String s : items) {
                if (!beginning.isEmpty() && !s.startsWith(beginning)) continue;
                m.add(s);
            }
            if (m.isEmpty()) {
                return "";
            }
            String[] matching = m.toArray(new String[m.size()]);
            Object res = "";
            while (beginning.length() + ((String)res).length() < matching[0].length()) {
                int k;
                char c = matching[0].charAt(beginning.length() + ((String)res).length());
                for (k = 1; k < matching.length && beginning.length() + ((String)res).length() < matching[k].length() && matching[k].charAt(beginning.length() + ((String)res).length()) == c; ++k) {
                }
                if (k < matching.length) break;
                res = (String)res + c;
            }
            return res;
        }

        @Override
        public String[] getAlternatives(String beginning) {
            EditListPopup.Item[] fullItems = this.getItems(beginning);
            if (fullItems == null || fullItems.length < 1) {
                return new String[0];
            }
            String[] items = new String[fullItems.length];
            for (int i = 0; i < fullItems.length; ++i) {
                items[i] = fullItems[i].getValue();
            }
            if (beginning == null || beginning.isEmpty()) {
                return items;
            }
            ArrayList<String> matching = new ArrayList<String>();
            for (String s : items) {
                if (!s.startsWith(beginning)) continue;
                matching.add(s);
            }
            return matching.toArray(new String[matching.size()]);
        }

        @Override
        public EditListPopup.Item getListPopupPreviousItem(String text) {
            if (text == null || text.isEmpty()) {
                return null;
            }
            EditListPopup.Item emptyItem = this.getEmptyItem(text);
            if (emptyItem == null) {
                return null;
            }
            if (text.compareTo(emptyItem.getValue()) <= 0) {
                return null;
            }
            EditListPopup.Item[] items = this.getItems(text);
            if (items == null || items.length <= 1) {
                return null;
            }
            if (text.compareTo(items[0].getValue()) <= 0) {
                return emptyItem;
            }
            for (int i = 1; i < items.length; ++i) {
                if (text.compareTo(items[i].getValue()) > 0) continue;
                return items[i - 1];
            }
            return items[items.length - 1];
        }

        @Override
        public EditListPopup.Item getListPopupNextItem(String text) {
            EditListPopup.Item[] items = this.getItems(text);
            if (text == null || text.isEmpty()) {
                return items != null && items.length > 0 ? items[0] : null;
            }
            if (items == null || items.length <= 1) {
                return null;
            }
            if (text.compareTo(items[items.length - 1].getValue()) >= 0) {
                return null;
            }
            for (int i = items.length - 2; i >= 0; --i) {
                if (text.compareTo(items[i].getValue()) < 0) continue;
                return items[i + 1];
            }
            return items[0];
        }
    }

    public static class DefaultAppearance
    implements EditListPopup.Appearance {
        protected final Luwrain luwrain;
        protected Luwrain.SpeakableTextType speakableTextType;

        public DefaultAppearance(Luwrain luwrain, Luwrain.SpeakableTextType speakableTextType) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)((Object)speakableTextType), (String)"speakableTextType");
            this.luwrain = luwrain;
            this.speakableTextType = speakableTextType;
        }

        public DefaultAppearance(Luwrain luwrain) {
            this(luwrain, Luwrain.SpeakableTextType.NATURAL);
        }

        @Override
        public void announceItem(EditListPopup.Item item, Set<EditListPopup.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            String value = item.getValue();
            if (!value.isEmpty()) {
                this.luwrain.setEventResponse(DefaultEventResponse.listItem(this.luwrain.getSpeakableText(value, this.speakableTextType)));
            } else {
                this.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            }
        }

        @Override
        public String getSpeakableText(String prefix, String text) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            NullCheck.notNull((Object)text, (String)"text");
            return prefix + this.luwrain.getSpeakableText(text, this.speakableTextType);
        }
    }

    public static class DefaultItem
    implements EditListPopup.Item {
        protected final String value;
        protected final String announcement;

        public DefaultItem() {
            this.value = "";
            this.announcement = "";
        }

        public DefaultItem(String value, String announcement) {
            NullCheck.notNull((Object)value, (String)"value");
            NullCheck.notNull((Object)announcement, (String)"announcement");
            this.value = value;
            this.announcement = announcement;
        }

        public DefaultItem(String value) {
            this(value, value);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getAnnouncement() {
            return this.announcement;
        }

        public String toString() {
            return this.value;
        }

        public int compareTo(Object o) {
            return this.value.compareTo(o.toString());
        }
    }
}

