/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.registry;

import org.luwrain.core.NullCheck;

public final class Path {
    private final boolean absolute;
    private final String[] dirItems;
    private final String valueName;

    public Path(boolean absolute, String[] dirItems, String valueName) {
        NullCheck.notNullItems((Object[])dirItems, (String)"dirItems");
        NullCheck.notNull((Object)valueName, (String)"valueName");
        this.absolute = absolute;
        this.dirItems = (String[])dirItems.clone();
        this.valueName = valueName;
        for (int i = 0; i < dirItems.length; ++i) {
            if (!dirItems[i].isEmpty()) continue;
            throw new IllegalArgumentException("dirItems[" + String.valueOf(i) + "] may not be empty");
        }
    }

    public Path(boolean absolute, String[] dirItems) {
        this(absolute, dirItems, "");
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isDirectory() {
        return this.valueName.isEmpty();
    }

    public boolean isRoot() {
        return this.absolute && this.dirItems.length < 1 && this.valueName.isEmpty();
    }

    public String[] dirItems() {
        return (String[])this.dirItems.clone();
    }

    public String valueName() {
        return this.valueName;
    }

    public Path getDirectory() {
        return new Path(this.absolute, this.dirItems);
    }

    public int getDirCount() {
        return this.dirItems.length;
    }

    public Path getParentOfDir() {
        if (this.dirItems.length < 1) {
            return this;
        }
        String[] newItems = new String[this.dirItems.length - 1];
        for (int i = 0; i < this.dirItems.length - 1; ++i) {
            newItems[i] = this.dirItems[i];
        }
        return new Path(this.absolute, newItems);
    }

    public String getLastDirItem() {
        if (this.dirItems.length < 1) {
            return "";
        }
        return this.dirItems[this.dirItems.length - 1];
    }

    public String toString() {
        Object res = this.absolute ? "/" : "";
        for (String s : this.dirItems) {
            res = (String)res + s + "/";
        }
        res = (String)res + this.valueName;
        return res;
    }
}

