/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.controls;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MutableLines;
import org.luwrain.script.ScriptUtils;

public final class EditSingleLineUpdateObj
implements ProxyObject {
    private static String[] KEYS = new String[]{"hotPoint", "line"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    protected final MutableLines lines;
    protected final HotPointControl hotPoint;

    public EditSingleLineUpdateObj(MutableLines lines, HotPointControl hotPoint) {
        this.lines = Objects.requireNonNull(lines, "lines can't be null");
        this.hotPoint = Objects.requireNonNull(hotPoint, "hotPoint can't be null");
    }

    public Object getMember(String name) {
        Objects.requireNonNull(name, "name can't be null");
        switch (name) {
            case "line": {
                return this.lines.getLine(this.hotPoint.getHotPointY());
            }
            case "hotPoint": {
                return this.hotPoint.getHotPointX();
            }
        }
        return null;
    }

    public void putMember(String name, Value value) {
        Objects.requireNonNull(name, "name can't be null");
        switch (name) {
            case "hotPoint": {
                int intValue = ScriptUtils.asInt(value);
                if (intValue < 0) {
                    throw new IllegalArgumentException("Value of a hot point can't be negative");
                }
                this.hotPoint.setHotPointX(intValue);
                return;
            }
            case "line": {
                this.lines.setLine(this.hotPoint.getHotPointY(), Objects.requireNonNullElse(ScriptUtils.asString(value), ""));
                return;
            }
        }
        throw new IllegalArgumentException("No such property: " + name);
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }
}

