/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;

final class ConstObj
implements ProxyObject {
    private static final String SOUND_PREFIX = "SOUND_";
    private static final String KEY_PREFIX = "KEY_";
    private static final String MESSAGE_TYPE_PREFIX = "MESSAGE_TYPE_";
    private static final EnumSet<Sounds> ALL_SOUNDS = EnumSet.allOf(Sounds.class);
    private static final EnumSet<InputEvent.Special> ALL_KEYS = EnumSet.allOf(InputEvent.Special.class);
    private static final EnumSet<Luwrain.MessageType> ALL_MESSAGE_TYPES = EnumSet.allOf(Luwrain.MessageType.class);
    private final String[] keys;
    private final Set<String> keysSet;
    private final ProxyArray keysArray;

    ConstObj() {
        ArrayList<CallSite> k = new ArrayList<CallSite>();
        for (Sounds sounds : ALL_SOUNDS) {
            k.add((CallSite)((Object)(SOUND_PREFIX + sounds.toString())));
        }
        for (InputEvent.Special special : ALL_KEYS) {
            k.add((CallSite)((Object)(KEY_PREFIX + special.toString().replaceAll("ARROW_", "MOVE_"))));
        }
        for (Luwrain.MessageType messageType : ALL_MESSAGE_TYPES) {
            k.add((CallSite)((Object)(MESSAGE_TYPE_PREFIX + messageType.toString())));
        }
        this.keys = k.toArray(new String[k.size()]);
        this.keysSet = new HashSet<String>(k);
        this.keysArray = ProxyArray.fromArray((Object[])this.keys);
    }

    public Object getMember(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        if (this.keysSet.contains(name)) {
            if (name.startsWith(KEY_PREFIX)) {
                return name.substring(KEY_PREFIX.length()).replaceAll("MOVE_", "ARROW_");
            }
            return name;
        }
        return null;
    }

    public boolean hasMember(String name) {
        return this.keysSet.contains(name);
    }

    public Object getMemberKeys() {
        return this.keysArray;
    }

    public void putMember(String name, Value value) {
        throw new RuntimeException("The const object doesn't support updating of its variables");
    }

    static Sounds getSound(String s) {
        NullCheck.notNull((Object)s, (String)"s");
        if (!s.startsWith(SOUND_PREFIX)) {
            return null;
        }
        String ss = s.substring(SOUND_PREFIX.length());
        for (Sounds k : ALL_SOUNDS) {
            if (!k.toString().equals(ss)) continue;
            return k;
        }
        return null;
    }

    static Luwrain.MessageType getMessageType(String s) {
        NullCheck.notNull((Object)s, (String)"s");
        if (!s.startsWith(MESSAGE_TYPE_PREFIX)) {
            return null;
        }
        String ss = s.substring(MESSAGE_TYPE_PREFIX.length());
        for (Luwrain.MessageType k : ALL_MESSAGE_TYPES) {
            if (!k.toString().equals(ss)) continue;
            return k;
        }
        return null;
    }
}

