/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.Value;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Worker;
import org.luwrain.script.core.LuwrainObj;

final class WorkerImpl
implements Worker {
    private final LuwrainObj luwrainObj;
    private final String name;
    private final int firstLaunchDelay;
    private final int launchPeriod;
    private final Value func;

    WorkerImpl(LuwrainObj luwrainObj, String name, int firstLaunchDelay, int launchPeriod, Value func) {
        NullCheck.notNull((Object)luwrainObj, (String)"luwrainObj");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)func, (String)"func");
        this.luwrainObj = luwrainObj;
        this.name = name;
        this.firstLaunchDelay = firstLaunchDelay;
        this.launchPeriod = launchPeriod;
        this.func = func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.luwrainObj.syncObj;
        synchronized (object) {
            this.func.execute(new Object[]{null, new Object[0]});
        }
    }

    @Override
    public int getFirstLaunchDelay() {
        return this.firstLaunchDelay;
    }

    @Override
    public int getLaunchPeriod() {
        return this.launchPeriod;
    }

    @Override
    public String getExtObjName() {
        return this.name;
    }
}

