/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.concurrent.atomic.AtomicBoolean;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;

public class NotificationHook {
    protected final HookContainer hookContainer;

    public NotificationHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public boolean run(String hookName, Object[] args) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        AtomicBoolean execRes = new AtomicBoolean(true);
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                hook.run(args);
            }
            catch (Throwable e) {
                execRes.set(false);
            }
            return HookContainer.HookResult.CONTINUE;
        });
        return execRes.get();
    }
}

