/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;

public class ProviderHook {
    protected static final Logger log = LogManager.getLogger();
    protected final HookContainer hookContainer;

    public ProviderHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public Object run(String hookName, Object[] args) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        AtomicReference res = new AtomicReference();
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                Object obj = hook.run(args);
                if (obj == null) {
                    return HookContainer.HookResult.CONTINUE;
                }
                res.set(obj);
                return HookContainer.HookResult.BREAK;
            }
            catch (Throwable ex) {
                log.catching(ex);
                res.set(ex);
                return HookContainer.HookResult.BREAK;
            }
        });
        if (res.get() == null) {
            return null;
        }
        Object v = res.get();
        if (v instanceof Throwable) {
            Throwable t = (Throwable)v;
            Object v2 = res.get();
            if (v2 instanceof RuntimeException) {
                RuntimeException r = (RuntimeException)v2;
                throw r;
            }
            throw new RuntimeException(t);
        }
        return res.get();
    }
}

