/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

public class TransformerHook {
    private static final String LOG_COMPONENT = "core";
    protected final HookContainer hookContainer;

    public TransformerHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public Object run(String hookName, Object obj) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNull((Object)obj, (String)"obj");
        AtomicReference<Object> o = new AtomicReference<Object>(obj);
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                Object res = hook.run(new Object[]{o.get()});
                if (res != null) {
                    o.set(res);
                }
                return HookContainer.HookResult.CONTINUE;
            }
            catch (RuntimeException e) {
                Log.error(LOG_COMPONENT, "the " + hookName + " hook thrown an exception: " + e.getClass().getName() + ": " + e.getMessage());
                return HookContainer.HookResult.CONTINUE;
            }
        });
        return o.get();
    }
}

