/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Settings;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

final class Braille
extends FormArea
implements SectionArea {
    private ControlPanel controlPanel;
    private Luwrain luwrain;
    private Settings.Braille settings;

    Braille(ControlPanel controlPanel) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), "\u0411\u0440\u0430\u0439\u043b\u044c");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.settings = null;
        this.fillForm();
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        System.out.println("saving " + this.getCheckboxState("enabled"));
        this.settings.setEnabled(this.getCheckboxState("enabled"));
        return true;
    }

    private void fillForm() {
        boolean activated = this.luwrain.getProperty("luwrain.braille.active").equals("1");
        this.addCheckbox("enabled", "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u0431\u0440\u0430\u0439\u043b\u044f:", this.settings.getEnabled(false));
        this.addStatic("activated", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e:" + (activated ? "\u0414\u0430" : "\u041d\u0435\u0442"));
        if (activated) {
            this.addStatic("driver", "\u0414\u0440\u0430\u0439\u0432\u0435\u0440:" + this.luwrain.getProperty("luwrain.braille.driver"));
            this.addStatic("display-width", "\u0428\u0438\u0440\u0438\u043d\u0430 \u0434\u0438\u0441\u043f\u043b\u0435\u044f:" + this.luwrain.getProperty("luwrain.braille.displaywidth"));
            this.addStatic("display-height", "\u0412\u044b\u0441\u043e\u0442\u0430 \u0434\u0438\u0441\u043f\u043b\u0435\u044f:" + this.luwrain.getProperty("luwrain.braille.displayheight"));
        } else {
            String error = this.luwrain.getProperty("luwrain.braille.error");
            if (!error.isEmpty()) {
                this.addStatic("error", "\u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438:" + error);
            }
        }
    }

    static Braille create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        return new Braille(controlPanel);
    }
}

