/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.EditableListArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefUtils;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.io.json.CommonSettings;
import org.luwrain.io.json.MainMenuItem;

final class MainMenu
extends EditableListArea<UniRefInfo>
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;

    MainMenu(ControlPanel controlPanel, EditableListArea.Params<UniRefInfo> params) {
        super(params);
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        NullCheck.notNull(params, (String)"params");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
    }

    @Override
    public boolean saveSectionData() {
        ListArea.Model model = this.getListModel();
        ArrayList<MainMenuItem> items = new ArrayList<MainMenuItem>();
        for (int i = 0; i < model.getItemCount(); ++i) {
            items.add(new MainMenuItem("uri", ((UniRefInfo)model.getItem(i)).getValue()));
        }
        this.luwrain.updateConf(CommonSettings.class, c -> c.setMainMenuItems(items));
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    static MainMenu create(ControlPanel controlPanel) {
        final Luwrain luwrain = Objects.requireNonNull(controlPanel, "controlPanel can't be null").getCoreInterface();
        ArrayList items = new ArrayList();
        CommonSettings conf = luwrain.loadConf(CommonSettings.class);
        if (conf != null) {
            items.addAll(Objects.requireNonNullElse(conf.getMainMenuItems(), List.of()));
        }
        ArrayList<UniRefInfo> uniRefs = new ArrayList<UniRefInfo>();
        if (items != null) {
            for (MainMenuItem item : items) {
                UniRefInfo info = UniRefUtils.make(luwrain, item.getValue());
                if (info == null) continue;
                uniRefs.add(info);
            }
        }
        EditableListArea.Params<UniRefInfo> params = new EditableListArea.Params<UniRefInfo>();
        params.context = new DefaultControlContext(luwrain);
        params.name = luwrain.i18n().getStaticStr("CpMainMenu");
        params.appearance = new Appearance(luwrain);
        params.model = new ListUtils.DefaultEditableModel<UniRefInfo>(UniRefInfo.class, uniRefs){

            @Override
            public UniRefInfo adjust(Object o) {
                NullCheck.notNull((Object)o, (String)"o");
                return UniRefUtils.make(luwrain, o);
            }
        };
        params.clipboardSaver = new ListUtils.FunctionalClipboardSaver<UniRefInfo>(entry -> entry, entry -> entry.getTitle());
        return new MainMenu(controlPanel, params);
    }

    private static final class Appearance
    extends ListUtils.DoubleLevelAppearance<UniRefInfo> {
        private static final String STATIC_PREFIX = "static:";

        Appearance(Luwrain luwrain) {
            super(new DefaultControlContext(luwrain));
        }

        @Override
        public boolean isSectionItem(UniRefInfo info) {
            NullCheck.notNull((Object)info, (String)"info");
            return info.getType().equals("section");
        }

        @Override
        public String getSectionScreenAppearance(UniRefInfo info) {
            NullCheck.notNull((Object)info, (String)"info");
            String title = info.getTitle();
            if (!title.startsWith(STATIC_PREFIX)) {
                return title;
            }
            return this.context.getI18n().getStaticStr(title.substring(STATIC_PREFIX.length()));
        }

        @Override
        public String getNonSectionScreenAppearance(UniRefInfo info) {
            NullCheck.notNull((Object)info, (String)"info");
            String title = info.getTitle();
            if (!title.startsWith(STATIC_PREFIX)) {
                return title;
            }
            return this.context.getI18n().getStaticStr(title.substring(STATIC_PREFIX.length()));
        }

        @Override
        public void announceNonSection(UniRefInfo info) {
            NullCheck.notNull((Object)info, (String)"info");
            this.context.setEventResponse(DefaultEventResponse.text(Sounds.DESKTOP_ITEM, this.context.getSpeakableText(this.getNonSectionScreenAppearance(info), Luwrain.SpeakableTextType.NATURAL)));
        }

        @Override
        public void announceSection(UniRefInfo info) {
            NullCheck.notNull((Object)info, (String)"info");
            this.context.setEventResponse(DefaultEventResponse.text(Sounds.DOC_SECTION, this.context.getSpeakableText(this.getNonSectionScreenAppearance(info), Luwrain.SpeakableTextType.NATURAL)));
        }
    }
}

