/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.shell;

import java.io.File;
import java.util.EnumSet;
import java.util.Objects;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.queries.UniRefAreaQuery;
import org.luwrain.popups.EditListPopup;
import org.luwrain.popups.EditListPopupUtils;
import org.luwrain.popups.FilePopup;
import org.luwrain.popups.Popups;
import org.luwrain.popups.YesNoPopup;
import org.luwrain.util.FileUtils;

public final class Conversations {
    private final Luwrain luwrain;

    public Conversations(Luwrain luwrain) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
    }

    public File open() {
        File current = new File(this.luwrain.getActiveAreaAttr(Luwrain.AreaAttr.DIRECTORY));
        FilePopup popup = new FilePopup(this.luwrain, this.luwrain.i18n().getStaticStr("OpenPopupName"), this.luwrain.i18n().getStaticStr("OpenPopupPrefix"), null, current, new File(this.luwrain.getDir("~")), Popups.loadFilePopupFlags(this.luwrain), Popups.DEFAULT_POPUP_FLAGS){

            @Override
            public boolean onInputEvent(InputEvent event) {
                Objects.requireNonNull(event, "event can't be null");
                if (event.isSpecial() && !event.isModified()) {
                    switch (event.getSpecial()) {
                        case INSERT: {
                            if (this.text().isEmpty()) {
                                return false;
                            }
                            File file = FileUtils.ifNotAbsolute(this.luwrain.getFileProperty("luwrain.dir.userhome"), this.text());
                            if (file.exists()) {
                                if (file.isDirectory()) {
                                    this.luwrain.message(this.luwrain.i18n().getStaticStr("DirAlreadyExists"), Luwrain.MessageType.ERROR);
                                } else {
                                    this.luwrain.message(this.luwrain.i18n().getStaticStr("FileAlreadyExists"), Luwrain.MessageType.ERROR);
                                }
                                return true;
                            }
                            if (file.mkdir()) {
                                this.luwrain.message(this.luwrain.i18n().getStaticStr("DirCreated"), Luwrain.MessageType.OK);
                            } else {
                                this.luwrain.message(this.luwrain.i18n().getStaticStr("UnableToCreateDir"), Luwrain.MessageType.ERROR);
                            }
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                switch (query.getQueryCode()) {
                    case 1: {
                        File f = FileUtils.ifNotAbsolute(this.luwrain.getFileProperty("luwrain.dir.userhome"), this.text);
                        if (f.getAbsolutePath().isEmpty()) {
                            return false;
                        }
                        ((UniRefAreaQuery)query).answer("file:" + f.getAbsolutePath());
                        return true;
                    }
                }
                return super.onAreaQuery(query);
            }
        };
        this.luwrain.popup(popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return popup.result();
    }

    public String command(final String[] allCommands) {
        Objects.requireNonNull(allCommands, "allCommands can't be null");
        EditListPopup popup = new EditListPopup(this.luwrain, new EditListPopupUtils.FixedModel(allCommands), new EditListPopupUtils.DefaultAppearance(this.luwrain, Luwrain.SpeakableTextType.PROGRAMMING), this.luwrain.i18n().getStaticStr("CommandPopupName"), this.luwrain.i18n().getStaticStr("CommandPopupPrefix"), "", EnumSet.noneOf(Popup.Flags.class)){

            @Override
            public boolean onOk() {
                String t = this.text.trim();
                if (t.isEmpty()) {
                    this.luwrain.playSound(Sounds.INACCESSIBLE);
                    return false;
                }
                for (String c : allCommands) {
                    if (!t.equals(c)) continue;
                    return true;
                }
                this.luwrain.message(this.luwrain.i18n().getStaticStr("NoCommand"), Luwrain.MessageType.ERROR);
                return false;
            }

            @Override
            public boolean onAreaQuery(AreaQuery query) {
                Objects.requireNonNull(query, "query can't be null");
                switch (query.getQueryCode()) {
                    case 1: {
                        if (this.text.trim().isEmpty()) {
                            return false;
                        }
                        ((UniRefAreaQuery)query).answer("command:" + this.text().trim());
                        return true;
                    }
                }
                return super.onAreaQuery(query);
            }
        };
        this.luwrain.popup(popup);
        if (popup.wasCancelled()) {
            return null;
        }
        return !popup.text().isEmpty() ? popup.text() : null;
    }

    public boolean deleteDesktopItemConfirmation(String name) {
        Objects.requireNonNull(name, "name can't be null");
        YesNoPopup popup = new YesNoPopup(this.luwrain, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"" + name + "\" \u0441 \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u0441\u0442\u043e\u043b\u0430?", false, Popups.DEFAULT_POPUP_FLAGS);
        this.luwrain.popup(popup);
        return !popup.wasCancelled() && popup.result();
    }

    public boolean deleteDesktopItemsConfirmation(int count) {
        YesNoPopup popup = new YesNoPopup(this.luwrain, "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + this.luwrain.i18n().getNumberStr(count, "items") + " \u0441 \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u0441\u0442\u043e\u043b\u0430?", false, Popups.DEFAULT_POPUP_FLAGS);
        this.luwrain.popup(popup);
        return !popup.wasCancelled() && popup.result();
    }
}

