/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.json.CommonSettings;
import org.luwrain.io.json.MainMenuItem;
import org.luwrain.popups.PopupClosingTranslator;

public final class MainMenu
extends ListArea<MainMenuItem>
implements PopupClosingTranslator.Provider {
    private final Luwrain luwrain;
    public final PopupClosingTranslator closing = new PopupClosingTranslator(this);
    private UniRefInfo result = null;

    private MainMenu(Luwrain luwrain, ListArea.Params<MainMenuItem> params) {
        super(params);
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.setListClickHandler((area, index, obj) -> this.closing.doOk());
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        if (this.closing.onSystemEvent(event)) {
            return true;
        }
        switch (event.getCode()) {
            case OK: {
                return this.closing.doOk();
            }
            case INTRODUCE: {
                this.luwrain.silence();
                this.luwrain.speak(this.getAreaName(), Sounds.MAIN_MENU);
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            default: 
        }
        return super.onAreaQuery(query);
    }

    @Override
    public boolean onOk() {
        MainMenuItem o = (MainMenuItem)this.selected();
        if (o == null) {
            return false;
        }
        Appearance appearance = (Appearance)this.getListAppearance();
        UniRefInfo uniRefInfo = appearance.getUniRefInfo(o);
        if (uniRefInfo == null) {
            return false;
        }
        if (uniRefInfo.getAddr().isEmpty()) {
            return false;
        }
        this.result = uniRefInfo;
        return true;
    }

    @Override
    public boolean onCancel() {
        return true;
    }

    public UniRefInfo result() {
        return this.result;
    }

    public static MainMenu newMainMenu(Luwrain luwrain) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        ArrayList items = new ArrayList();
        CommonSettings conf = luwrain.loadConf(CommonSettings.class);
        if (conf != null) {
            items.addAll(Objects.requireNonNullElse(conf.getMainMenuItems(), new ArrayList()));
        }
        ListArea.Params<MainMenuItem> params = new ListArea.Params<MainMenuItem>();
        params.context = new DefaultControlContext(luwrain);
        final Appearance appearance = new Appearance(params.context);
        params.model = new ListUtils.ListModel(items);
        params.appearance = appearance;
        params.transition = new Transition(params.model, (Appearance)params.appearance);
        params.name = luwrain.i18n().getStaticStr("MainMenuName");
        params.clipboardSaver = new ListUtils.DefaultClipboardSaver<MainMenuItem>(){

            @Override
            protected Object getClipboardObj(ListArea.Appearance<MainMenuItem> a, MainMenuItem item) {
                NullCheck.notNull(a, (String)"a");
                NullCheck.notNull((Object)item, (String)"item");
                return appearance.getUniRefInfo(item);
            }

            @Override
            protected String getClipboardString(ListArea.Appearance<MainMenuItem> a, MainMenuItem item) {
                NullCheck.notNull(a, (String)"a");
                NullCheck.notNull((Object)item, (String)"item");
                return appearance.getUniRefInfo(item).getTitle();
            }
        };
        return new MainMenu(luwrain, params);
    }

    static final class Appearance
    extends ListUtils.DoubleLevelAppearance<MainMenuItem> {
        private static final String STATIC_PREFIX = "static:";
        private final Map<String, UniRefInfo> uniRefCache = new HashMap<String, UniRefInfo>();

        Appearance(ControlContext context) {
            super(context);
        }

        @Override
        public boolean isSectionItem(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            UniRefInfo info = this.getUniRefInfo(item);
            return info.getType().equals("section");
        }

        @Override
        public String getSectionScreenAppearance(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            UniRefInfo info = this.getUniRefInfo(item);
            String title = info.getTitle();
            if (!title.startsWith(STATIC_PREFIX)) {
                return title;
            }
            return this.context.getI18n().getStaticStr(title.substring(STATIC_PREFIX.length()));
        }

        @Override
        public String getNonSectionScreenAppearance(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            UniRefInfo info = this.getUniRefInfo(item);
            String title = info.getTitle();
            if (!title.startsWith(STATIC_PREFIX)) {
                return title;
            }
            return this.context.getI18n().getStaticStr(title.substring(STATIC_PREFIX.length()));
        }

        @Override
        public void announceNonSection(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            this.context.setEventResponse(DefaultEventResponse.text(Sounds.MAIN_MENU_ITEM, this.context.getSpeakableText(this.getNonSectionScreenAppearance(item), Luwrain.SpeakableTextType.NATURAL)));
        }

        @Override
        public void announceSection(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            this.context.setEventResponse(DefaultEventResponse.text(Sounds.DOC_SECTION, this.context.getSpeakableText(this.getNonSectionScreenAppearance(item), Luwrain.SpeakableTextType.NATURAL)));
        }

        UniRefInfo getUniRefInfo(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            String value = item.getValue();
            if (this.uniRefCache.containsKey(value)) {
                return this.uniRefCache.get(value);
            }
            UniRefInfo info = this.context.getUniRefInfo(value);
            this.uniRefCache.put(value, info);
            return info;
        }
    }

    private static class Transition
    extends ListUtils.DoubleLevelTransition<MainMenuItem> {
        private final Appearance appearance;

        Transition(ListArea.Model<MainMenuItem> model, Appearance appearance) {
            super(model);
            NullCheck.notNull((Object)appearance, (String)"appearance");
            this.appearance = appearance;
        }

        @Override
        public boolean isSectionItem(MainMenuItem item) {
            NullCheck.notNull((Object)item, (String)"item");
            return this.appearance.isSectionItem(item);
        }

        @Override
        public ListArea.Transition.State transition(ListArea.Transition.Type type, ListArea.Transition.State fromState, int itemCount, boolean hasEmptyLineTop, boolean hasEmptyLineBottom) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)fromState, (String)"fromState");
            if (itemCount == 0) {
                throw new IllegalArgumentException("itemCount must be greater than zero");
            }
            switch (type) {
                case SINGLE_DOWN: {
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX || fromState.itemIndex + 1 != itemCount) {
                        return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
                    }
                    return new ListArea.Transition.State(0);
                }
                case SINGLE_UP: {
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX || fromState.itemIndex != 0) {
                        return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
                    }
                    return new ListArea.Transition.State(itemCount - 1);
                }
            }
            return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
        }
    }
}

