/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;

public final class ClassUtils {
    private static final String LOG_COMPONENT = "core";

    public static Object newInstanceOf(ClassLoader classLoader, String className, Class ensureInstanceOf) {
        Object obj;
        NullCheck.notNull((Object)classLoader, (String)"classLoader");
        NullCheck.notEmpty((Object)className, (String)"className");
        try {
            obj = Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            Log.error(LOG_COMPONENT, "unable to create an instance of the class " + className + ":" + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
        if (ensureInstanceOf == null) {
            return obj;
        }
        if (!ensureInstanceOf.isInstance(obj)) {
            Log.error(LOG_COMPONENT, "the newly created instance of the class " + className + " is not an instance of " + ensureInstanceOf.getName());
            return null;
        }
        return obj;
    }
}

