/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Random;
import org.luwrain.util.Sha1;
import org.luwrain.util.StreamUtils;

public final class FileUtils {
    public static final String UTF_8 = "UTF_8";

    public static String writeRandomFile(Path path, int len) throws IOException {
        byte[] data = new byte[len];
        new Random().nextBytes(data);
        Files.write(path, data, new OpenOption[0]);
        return Sha1.getSha1(data);
    }

    public static String readTextFile(File file, String charset) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        try (FileInputStream is = new FileInputStream(file);){
            String string = new String(StreamUtils.readAllBytes(is), charset);
            return string;
        }
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtils.readTextFile(file, UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text, String charset) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(text, "text can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            StreamUtils.writeAllBytes(os, text.getBytes(charset));
        }
        finally {
            os.flush();
            ((OutputStream)os).close();
        }
    }

    public static String[] readTextFileMultipleStrings(File file, String charset, String lineSeparator) throws IOException {
        Objects.requireNonNull(file, "file can't be null");
        Objects.requireNonNull(charset, "charset can't be null");
        if (charset.isEmpty()) {
            throw new IllegalArgumentException("charset can't be empty");
        }
        String text = FileUtils.readTextFile(file, charset);
        if (text.isEmpty()) {
            return new String[0];
        }
        return text.split(lineSeparator != null ? lineSeparator : System.getProperty("line.separator"), -1);
    }

    public static File ifNotAbsolute(File baseDir, String path) {
        Objects.requireNonNull(baseDir, "baseDir can't be null");
        Objects.requireNonNull(path, "path can't be null");
        if (path.isEmpty()) {
            throw new IllegalArgumentException("path can't be empty");
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(baseDir, path);
    }
}

