/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class TextUtils {
    public static String[] splitLines(String text) {
        Objects.requireNonNull(text, "text can't be null");
        return text.replaceAll("\r\n", "\r").replaceAll("\r", "\n").split("\n", -1);
    }

    public static List<String> splitLinesAsList(String text) {
        return Arrays.asList(TextUtils.splitLines(text));
    }

    public static String notLonger(String str, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength can't be negative");
        }
        return str.length() <= maxLength ? str : str.substring(0, maxLength);
    }

    public static String getLastWord(String text, int upToPos) {
        Objects.requireNonNull(text, "text can't be null");
        Object word = new String();
        boolean broken = false;
        for (int i = 0; i < text.length() && i < upToPos; ++i) {
            char c = text.charAt(i);
            if (Character.getType(c) == 1 || Character.getType(c) == 2 || Character.getType(c) == 9) {
                if (broken) {
                    word = "";
                }
                broken = false;
                word = (String)word + c;
                continue;
            }
            broken = true;
        }
        return word;
    }

    public static String sameCharString(char c, int count) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            b.append(c);
        }
        return new String(b);
    }

    public static String removeIsoControlChars(String value) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isISOControl(value.charAt(i))) continue;
            b.append(value.charAt(i));
        }
        return b.toString();
    }

    public static String replaceIsoControlChars(String value, char replaceWith) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isISOControl(value.charAt(i))) {
                b.append(value.charAt(i));
                continue;
            }
            b.append(replaceWith);
        }
        return b.toString();
    }

    public static String replaceIsoControlChars(String value) {
        return TextUtils.replaceIsoControlChars(value, ' ');
    }

    public static String[] wordWrap(String line, int width) {
        if (width < 3) {
            throw new IllegalArgumentException("width (" + String.valueOf(width) + ") can't be less than 3");
        }
        ArrayList<String> res = new ArrayList<String>();
        String[] words = line.split(" ", -1);
        StringBuilder b = new StringBuilder();
        for (String word : words) {
            if (word.trim().isEmpty()) continue;
            if (b.length() + word.length() + 1 > width) {
                res.add(new String(b));
                b = new StringBuilder();
            }
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(word);
        }
        if (b.length() > 0) {
            res.add(new String(b));
        }
        return res.toArray(new String[res.size()]);
    }
}

