/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.linux_rec;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.linux_rec.App;
import org.luwrain.app.linux_rec.Entry;
import org.luwrain.app.linux_rec.Strings;
import org.luwrain.app.linux_rec.layouts.RecordingProgressLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.events.InputEvent;

final class MainLayout
extends LayoutBase {
    private static final Logger log = LogManager.getLogger();
    final App app;
    final ListArea<Entry> entriesArea;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.entriesArea = new ListArea(this.listParams(p -> {
            p.model = new ListUtils.ListModel(app.conf.entries);
            p.appearance = new MainListAppearance();
            p.name = s.entriesAreaName();
        }));
        this.setAreaLayout((Area)this.entriesArea, this.actions(new LayoutBase.ActionInfo[]{this.action("rec", s.actionRec(), new InputEvent(InputEvent.Special.F5), this::onStartRecording)}));
    }

    boolean onStartRecording() {
        this.app.setAreaLayout(new RecordingProgressLayout(this.app, this.getReturnAction(), this.entriesArea));
        this.getLuwrain().announceActiveArea();
        return true;
    }

    final class MainListAppearance
    extends ListUtils.DoubleLevelAppearance<Entry> {
        MainListAppearance() {
            super(MainLayout.this.getControlContext());
        }

        public boolean isSectionItem(Entry entry) {
            return false;
        }

        public void announceNonSection(Entry entry) {
            MainLayout.this.app.setEventResponse(DefaultEventResponse.listItem((String)Objects.requireNonNullElse(entry.name, "")));
        }

        public String getNonSectionScreenAppearance(Entry entry) {
            return Objects.requireNonNullElse(entry.name, "");
        }
    }
}

