/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.osm.model;

import java.util.Map;
import org.luwrain.io.api.osm.model.Element;

public final class Node
extends Element {
    private final double lat;
    private final double lon;

    public Node(long id, Map<String, String> tags, double lat, double lon) {
        super(id, tags);
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        return Double.compare(this.getLon(), other.getLon()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        long $lon = Double.doubleToLongBits(this.getLon());
        result = result * 59 + (int)($lon >>> 32 ^ $lon);
        return result;
    }

    @Override
    public String toString() {
        return "Node(lat=" + this.getLat() + ", lon=" + this.getLon() + ")";
    }
}

