/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.searx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Searx {
    private static final Logger log = LogManager.getLogger();
    private static final Gson gson = new Gson();
    final String endpoint;

    public Searx(String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint can't be null");
        if (endpoint.isEmpty()) {
            throw new IllegalArgumentException("endpoint can't be empty");
        }
    }

    public Response request(String query) throws IOException {
        String requestMethod = "GET";
        String url = this.endpoint;
        String payload = "q=" + URLEncoder.encode(query, StandardCharsets.UTF_8) + "&format=json";
        log.trace("Searx request: url=" + url + ", payload=" + payload);
        String[] headers = new String[]{"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0", "Accept: */*", "Accept-Encoding: gzip, deflate", "Connection: keep-alive", "Accept-Language: ru-RU,ru;q=0.8,en-US;q=0.5,en;q=0.3", "Content-Type: application/x-www-form-urlencoded"};
        return this.sendRequest(url, "GET", payload, headers);
    }

    Response sendRequest(String url, String method, String payload, String[] headers) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpRequestBase request = this.createRequest(method, url, payload, headers);
            Response response = this.executeRequest(httpClient, request);
            return response;
        }
    }

    HttpRequestBase createRequest(String method, String url, String payload, String[] headers) throws IOException {
        HttpGet request;
        if ("GET".equalsIgnoreCase(method)) {
            request = new HttpGet(url + "?" + payload);
        } else if ("POST".equalsIgnoreCase(method)) {
            HttpPost postRequest = new HttpPost(url);
            postRequest.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
            request = postRequest;
        } else {
            throw new IllegalArgumentException("Unsupported request method: " + method);
        }
        for (String header : headers) {
            String[] headerParts = header.split(": ");
            request.addHeader(headerParts[0], headerParts[1]);
        }
        return request;
    }

    Response executeRequest(CloseableHttpClient httpClient, HttpRequestBase request) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Response response2 = (Response)gson.fromJson(this.handleResponse(response), Response.class);
            return response2;
        }
    }

    String handleResponse(CloseableHttpResponse response) throws IOException {
        ArrayList links = new ArrayList();
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new NullPointerException("entity");
        }
        String responseString = EntityUtils.toString((HttpEntity)entity);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("status code: " + response.getStatusLine().getStatusCode());
        }
        if (this.isJson(responseString)) {
            return responseString;
        }
        log.error("Received non-JSON response or error code: " + String.valueOf(response.getStatusLine()));
        log.error("Response: " + responseString);
        return null;
    }

    boolean isJson(String responseString) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(responseString);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final class Response {
        public String query;
        public int number_of_results;
        public List<Item> results;
    }

    public static final class Item {
        public String url;
        public String title;
        public String content;
        public String engine;
        public String template;
        public String category;
        public String thumbnail;
        public List<String> parsed_url;
        public List<String> engines;
        List<Integer> positions;
        float score;
    }
}

