/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.yandex.translate;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.luwrain.io.api.yandex.translate.model.Request;
import org.luwrain.io.api.yandex.translate.model.Response;

public final class YandexTranslate {
    private static final String URL = "https://translate.api.cloud.yandex.net/translate/v2/translate";
    private static final Gson gson = new Gson();
    private final String apiKey;

    public YandexTranslate(String apiKey) {
        this.apiKey = Objects.requireNonNull(apiKey, "apiKey can't be null");
    }

    public Response request(Request request) throws IOException {
        URL url = new URL(URL);
        StringBuilder b = new StringBuilder();
        gson.toJson((Object)request, (Appendable)b);
        byte[] postData = new String(b).getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setInstanceFollowRedirects(false);
        httpCon.setRequestMethod("POST");
        httpCon.setRequestProperty("Authorization", "Api-Key " + this.apiKey);
        httpCon.setRequestProperty("Content-Type", "application/json");
        httpCon.setRequestProperty("charset", "utf-8");
        httpCon.setRequestProperty("Content-Length", Integer.toString(postData.length));
        httpCon.setUseCaches(false);
        try (DataOutputStream w = new DataOutputStream(httpCon.getOutputStream());){
            w.write(postData);
            w.flush();
        }
        if (httpCon.getResponseCode() != 200) {
            throw new IllegalStateException("HTTP Code is " + httpCon.getResponseCode());
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(httpCon.getInputStream(), StandardCharsets.UTF_8));){
            Response response = (Response)gson.fromJson((Reader)r, Response.class);
            return response;
        }
    }
}

