/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.vfs;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.ControlContext;
import org.luwrain.io.vfs.CommanderAppearance;
import org.luwrain.io.vfs.CommanderModel;

public final class CommanderUtils {
    private static final Logger log = LogManager.getLogger();

    public static CommanderArea.Params<FileObject> createParams(ControlContext context) throws FileSystemException {
        Objects.requireNonNull(context, "context can't be null");
        CommanderArea.Params params = new CommanderArea.Params();
        FileSystemManager manager = VFS.getManager();
        params.context = context;
        params.model = new CommanderModel(manager);
        params.appearance = new CommanderAppearance(context, manager);
        params.filter = new CommanderUtils.AllEntriesFilter();
        params.comparator = new CommanderUtils.ByNameComparator();
        return params;
    }

    public static FileObject createInitialFileObject(CommanderModel model, String path) throws FileSystemException {
        Objects.requireNonNull(model, "model can't be null");
        Objects.requireNonNull(path, "path can't be null");
        FileSystemOptions opts = new FileSystemOptions();
        return model.getFileSystemManager().resolveFile(path, opts);
    }

    public static class NoHiddenFilter
    implements CommanderArea.Filter<FileObject> {
        public boolean commanderEntrySuits(FileObject entry) {
            Objects.requireNonNull(entry, "entry can't be null");
            try {
                return !entry.isHidden();
            }
            catch (IOException e) {
                log.error("Unable to get attributes of " + entry.toString() + ":" + e.getClass().getName() + ":" + e.getMessage());
                return true;
            }
        }
    }
}

