/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp.ru;

import org.luwrain.core.NullCheck;
import org.luwrain.nlp.GrammaticalAttr;

public final class GramAttr
implements GrammaticalAttr {
    private final Gender gender;
    private final Number number;
    private final Case gcase;

    public GramAttr(Gender gender, Number number, Case gcase) {
        this.gender = gender;
        this.number = number;
        this.gcase = gcase;
    }

    public GramAttr(GramAttr a1, GramAttr a2) {
        this.gender = a2.getGender() != null ? a2.getGender() : a1.getGender();
        this.number = a2.getNumber() != null ? a2.getNumber() : a1.getNumber();
        this.gcase = a2.getCase() != null ? a2.getCase() : a1.getCase();
    }

    public Gender getGender() {
        return this.gender;
    }

    public Number getNumber() {
        return this.number;
    }

    public Case getCase() {
        return this.gcase;
    }

    public static GramAttr fromString(String s) {
        NullCheck.notNull((Object)s, (String)"s");
        String[] items = s.replaceAll(";", ",").split(",", -1);
        Gender g = null;
        Case c = null;
        Number n = null;
        for (String i : items) {
            String k = i.trim();
            if (k.length() < 2) continue;
            Gender gg = Gender.find(k);
            Case cc = Case.find(k);
            Number nn = Number.find(k);
            if (cc != null) {
                c = cc;
                continue;
            }
            if (nn != null) {
                n = nn;
                continue;
            }
            if (gg == null) continue;
            g = gg;
        }
        return new GramAttr(g, n, c);
    }

    public static enum Gender {
        MASCULINE,
        FEMININE,
        NEUTER;


        public static Gender find(String s) {
            NullCheck.notNull((Object)s, (String)"s");
            switch (s.toUpperCase()) {
                case "M": 
                case "MASC": 
                case "MASCULINE": {
                    return MASCULINE;
                }
                case "F": 
                case "FEM": 
                case "FEMININE": {
                    return FEMININE;
                }
                case "N": 
                case "NEU": 
                case "NEUTER": {
                    return NEUTER;
                }
            }
            return null;
        }
    }

    public static enum Number {
        SINGULAR,
        PLURAL;


        public static Number find(String s) {
            NullCheck.notNull((Object)s, (String)"s");
            switch (s.toUpperCase()) {
                case "S": 
                case "SG": 
                case "SINGULAR": {
                    return SINGULAR;
                }
                case "P": 
                case "PL": 
                case "PLURAL": {
                    return PLURAL;
                }
            }
            return null;
        }
    }

    public static enum Case {
        NOM,
        GEN,
        DAT,
        ACC,
        INST,
        PRAE;


        public static Case find(String s) {
            NullCheck.notNull((Object)s, (String)"s");
            switch (s.toUpperCase()) {
                case "N": 
                case "NOM": {
                    return NOM;
                }
                case "G": 
                case "GEN": {
                    return GEN;
                }
                case "D": 
                case "DAT": {
                    return DAT;
                }
                case "A": 
                case "ACC": {
                    return ACC;
                }
                case "I": 
                case "INS": 
                case "INST": {
                    return INST;
                }
                case "P": 
                case "PRE": 
                case "PRA": 
                case "PRAE": {
                    return PRAE;
                }
            }
            return null;
        }
    }
}

