/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp.ru.spell;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Russian;
import org.languagetool.rules.RuleMatch;
import org.luwrain.core.Luwrain;
import org.luwrain.nlp.Hunspell;
import org.luwrain.nlp.SpellChecker;
import org.luwrain.nlp.SpellExclusion;
import org.luwrain.nlp.SpellProblem;
import org.luwrain.nlp.ru.spell.Problem;

public final class RuSpellChecker
implements SpellChecker {
    final JLanguageTool langTool = new JLanguageTool((Language)new Russian());
    final Hunspell hunspell;
    final SpellExclusion exclusion;

    public RuSpellChecker(Luwrain luwrain) {
        File hunspellDataDir = new File(luwrain.getFileProperty("luwrain.dir.data"), "hunspell");
        File dictFile = new File(hunspellDataDir, "ru_RU.dic");
        File affFile = new File(hunspellDataDir, "ru_RU.aff");
        this.hunspell = new Hunspell(dictFile.getAbsolutePath(), affFile.getAbsolutePath());
        this.exclusion = new SpellExclusion(luwrain);
        this.exclusion.load();
    }

    RuSpellChecker() {
        this.hunspell = null;
        this.exclusion = null;
    }

    @Override
    public List<SpellProblem> check(String text) {
        ArrayList<SpellProblem> res = new ArrayList<SpellProblem>();
        try {
            List m = this.langTool.check(text);
            for (RuleMatch mm : m) {
                res.add(new Problem(mm));
            }
            return res;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> suggestCorrections(String word) {
        if (this.hunspell == null) {
            throw new IllegalStateException("Hunspell not initialized");
        }
        return this.hunspell.suggest(word);
    }

    @Override
    public SpellExclusion getExclusion() {
        return this.exclusion;
    }
}

