/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.opds;

import java.util.Set;
import org.luwrain.app.opds.Opds;
import org.luwrain.app.opds.Strings;
import org.luwrain.app.opds.Utils;
import org.luwrain.controls.ListArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Suggestions;

final class Appearance
implements ListArea.Appearance<Opds.Entry> {
    private final Luwrain luwrain;
    private final Strings strings;

    Appearance(Luwrain luwrain, Strings strings) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.luwrain = luwrain;
        this.strings = strings;
    }

    public void announceItem(Opds.Entry entry, Set<ListArea.Appearance.Flags> flags) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull(flags, (String)"flags");
        this.luwrain.setEventResponse(DefaultEventResponse.listItem((String)Appearance.getString(entry), (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
    }

    public String getScreenAppearance(Opds.Entry entry, Set<ListArea.Appearance.Flags> flags) {
        NullCheck.notNull((Object)entry, (String)"entry");
        NullCheck.notNull(flags, (String)"flags");
        if (Utils.isCatalogOnly(entry)) {
            return "[" + Appearance.getString(entry) + "]";
        }
        return " " + Appearance.getString(entry) + " ";
    }

    public int getObservableLeftBound(Opds.Entry entry) {
        return entry != null ? 1 : 0;
    }

    public int getObservableRightBound(Opds.Entry entry) {
        if (entry == null) {
            return 0;
        }
        return Appearance.getString(entry).length() + 1;
    }

    private static String getString(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        if (entry.authors == null || entry.authors.length == 0) {
            return entry.title;
        }
        return entry.authors[0].name + " - " + entry.title;
    }
}

