/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.opds;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.luwrain.app.opds.Opds;
import org.luwrain.core.NullCheck;

final class Utils {
    static final String CONTENT_TYPE_FB2_ZIP = "application/fb2+zip";
    static final String PROFILE_CATALOG = "opds-catalog";
    static final String BASE_TYPE_CATALOG = "application/atom+xml";
    static final String PRIMARY_TYPE_IMAGE = "image";

    Utils() {
    }

    static Opds.Link getCatalogLink(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        for (Opds.Link link : entry.links) {
            if (!Utils.isCatalog(link)) continue;
            return link;
        }
        return null;
    }

    static boolean isCatalogOnly(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        for (Opds.Link link : entry.links) {
            if (Utils.isCatalog(link)) continue;
            return false;
        }
        return true;
    }

    static boolean hasCatalogLinks(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        for (Opds.Link link : entry.links) {
            if (!Utils.isCatalog(link)) continue;
            return true;
        }
        return false;
    }

    static boolean hasBooks(Opds.Entry entry) {
        NullCheck.notNull((Object)entry, (String)"entry");
        for (Opds.Link link : entry.links) {
            if (Utils.isCatalog(link) || Utils.isImage(link)) continue;
            return true;
        }
        return false;
    }

    static boolean isCatalog(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        if (Utils.getTypeProfile(link).toLowerCase().equals(PROFILE_CATALOG)) {
            return true;
        }
        return Utils.getBaseType(link).equals(BASE_TYPE_CATALOG);
    }

    static boolean isImage(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        return Utils.getPrimaryType(link).toLowerCase().trim().equals(PRIMARY_TYPE_IMAGE);
    }

    static String getBaseType(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        if (link.type == null) {
            return "";
        }
        try {
            MimeType mime = new MimeType(link.type);
            String value = mime.getBaseType();
            return value != null ? value : "";
        }
        catch (MimeTypeParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    static String getPrimaryType(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        if (link.type == null) {
            return "";
        }
        try {
            MimeType mime = new MimeType(link.type);
            String value = mime.getPrimaryType();
            return value != null ? value : "";
        }
        catch (MimeTypeParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    static String getSubType(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        if (link.type == null) {
            return "";
        }
        try {
            MimeType mime = new MimeType(link.type);
            String value = mime.getSubType();
            return value != null ? value : "";
        }
        catch (MimeTypeParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    static String getTypeProfile(Opds.Link link) {
        NullCheck.notNull((Object)link, (String)"link");
        if (link.type == null) {
            return "";
        }
        try {
            MimeType mime = new MimeType(link.type);
            String value = mime.getParameter("profile");
            return value != null ? value : "";
        }
        catch (MimeTypeParseException e) {
            e.printStackTrace();
            return "";
        }
    }
}

