/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.news.Conv;
import org.luwrain.app.news.GroupWrapper;
import org.luwrain.app.news.MainLayout;
import org.luwrain.app.news.Strings;
import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.MonoApp;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.pim.news.persist.Group;
import org.luwrain.pim.news.persist.NewsPersistence;
import org.luwrain.pim.workers.News;

public final class App
extends AppBase<Strings>
implements MonoApp {
    public NewsPersistence persist = null;
    private MainLayout mainLayout = null;
    Conv conv = null;
    private Group group = null;
    boolean showAllGroups = false;
    final List<GroupWrapper> groups = new ArrayList<GroupWrapper>();
    final List<Article> articles = new ArrayList<Article>();

    public App() {
        super(Strings.class, "luwrain.news");
    }

    public AreaLayout onAppInit() throws Exception {
        this.persist = (NewsPersistence)this.getLuwrain().createInstance(NewsPersistence.class);
        if (this.persist == null) {
            throw new Exception("No news persistence");
        }
        this.conv = new Conv(this);
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        this.loadGroups();
        this.runFetching();
        return this.mainLayout.getAreaLayout();
    }

    boolean openGroup(Group newGroup) {
        this.group = newGroup;
        this.loadArticles();
        return true;
    }

    void loadGroups() {
        List g = this.persist.getGroupDAO().load();
        this.groups.clear();
        this.groups.addAll(g.stream().map(e -> new GroupWrapper((Group)e, 0)).toList());
    }

    void loadArticles() {
        this.articles.clear();
        if (this.group == null) {
            return;
        }
        this.articles.addAll(this.persist.getArticleDAO().load(this.group, a -> a.getStatus() != Article.Status.READ));
        if (this.articles.isEmpty()) {
            this.articles.addAll(this.persist.getArticleDAO().load(this.group));
        }
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public boolean onSystemEvent(Area area, SystemEvent event) {
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(area, event);
        }
        switch (event.getCode()) {
            case REFRESH: {
                this.runFetching();
                return true;
            }
        }
        return super.onSystemEvent(area, event);
    }

    void runFetching() {
        this.getLuwrain().runWorker(News.NAME);
    }

    public MonoApp.Result onMonoAppSecondInstance(Application app) {
        this.runFetching();
        return MonoApp.Result.BRING_FOREGROUND;
    }
}

