/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.news;

import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.news.App;
import org.luwrain.app.news.GroupWrapper;
import org.luwrain.app.news.Strings;
import org.luwrain.app.news.layouts.GroupPropertiesLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.news.persist.Article;
import org.luwrain.pim.news.persist.Group;
import org.luwrain.reader.Document;
import org.luwrain.reader.DocumentBuilder;
import org.luwrain.reader.DocumentBuilderLoader;

final class MainLayout
extends LayoutBase {
    final App app;
    final ListArea<GroupWrapper> groupsArea;
    final ListArea<Article> summaryArea;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.groupsArea = new ListArea(this.listParams(p -> {
            p.name = ((Strings)app.getStrings()).groupsAreaName();
            p.model = new ListUtils.ListModel<GroupWrapper>(app.groups){

                public void refresh() {
                    app.loadGroups();
                }
            };
            p.appearance = new ListUtils.DefaultAppearance(p.context, Suggestions.CLICKABLE_LIST_ITEM);
            p.clickHandler = (area, index, group) -> this.onGroupsClick((GroupWrapper)group);
        }));
        this.setPropertiesHandler((Area)this.groupsArea, a -> {
            GroupWrapper g = (GroupWrapper)this.groupsArea.selected();
            if (g == null) {
                return null;
            }
            return new GroupPropertiesLayout(app, g.group, this.getReturnAction());
        });
        LayoutBase.Actions groupsActions = this.actions(new LayoutBase.ActionInfo[]{this.action("show-read", ((Strings)app.getStrings()).actionShowWithReadOnly(), new InputEvent('='), () -> this.setShowAllGroupsMode(true)), this.action("hide-read", ((Strings)app.getStrings()).actionHideWithReadOnly(), new InputEvent('-'), () -> this.setShowAllGroupsMode(false)), this.action("delete-group", ((Strings)app.getStrings()).actionDeleteGroup(), new InputEvent(InputEvent.Special.DELETE, EnumSet.of(InputEvent.Modifiers.SHIFT)), this::actDeleteGroup), this.action("add-group", ((Strings)app.getStrings()).actionAddGroup(), new InputEvent(InputEvent.Special.INSERT), this::actNewGroup)});
        this.summaryArea = new ListArea<Article>(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).summaryAreaName();
            params.model = new ListUtils.ListModel(app.articles);
            params.appearance = new SummaryAppearance();
            params.clickHandler = (area, index, article) -> this.onSummaryClick((Article)article);
            params.flags.add(ListArea.Flags.AREA_ANNOUNCE_SELECTED);
        })){

            public boolean onInputEvent(InputEvent event) {
                if (!event.isModified() && !event.isSpecial()) {
                    switch (event.getChar()) {
                        case ' ': {
                            return MainLayout.this.onSummarySpace();
                        }
                    }
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case OK: {
                            return MainLayout.this.openArticleUrl();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        LayoutBase.Actions summaryActions = this.actions(new LayoutBase.ActionInfo[0]);
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.groupsArea, groupsActions, (Area)this.summaryArea, summaryActions);
    }

    private boolean actMarkAsReadWholeGroup() {
        GroupWrapper wrapper = (GroupWrapper)this.groupsArea.selected();
        if (wrapper == null) {
            return false;
        }
        Group group = wrapper.group;
        List articles = this.app.persist.getArticleDAO().load(group, a -> a.getStatus() != Article.Status.READ);
        if (articles == null) {
            return true;
        }
        for (Article a2 : articles) {
            if (a2.getStatus() != Article.Status.NEW) continue;
            a2.setStatus(Article.Status.READ);
            this.app.persist.getArticleDAO().update(a2);
        }
        return true;
    }

    private boolean onGroupsClick(GroupWrapper group) {
        this.app.openGroup(group.group);
        this.summaryArea.reset(false);
        this.summaryArea.refresh();
        this.setActiveArea((Area)this.summaryArea);
        return true;
    }

    private boolean actNewGroup() {
        String name = this.app.conv.newGroupName();
        if (name == null) {
            return false;
        }
        Group group = new Group();
        group.setName(name);
        this.app.persist.getGroupDAO().add(group);
        this.app.showAllGroups = true;
        this.app.loadGroups();
        this.groupsArea.refresh();
        for (GroupWrapper g : this.app.groups) {
            if (!g.group.getName().equals(name)) continue;
            this.groupsArea.select((Object)g, true);
            break;
        }
        return true;
    }

    private boolean actDeleteGroup() {
        GroupWrapper wrapper = (GroupWrapper)this.groupsArea.selected();
        if (wrapper == null) {
            return false;
        }
        if (!this.app.conv.confirmGroupDeleting(wrapper)) {
            return true;
        }
        this.app.persist.getGroupDAO().delete(wrapper.group);
        this.app.loadGroups();
        this.groupsArea.refresh();
        return true;
    }

    private boolean openArticleUrl() {
        Article article = (Article)this.summaryArea.selected();
        if (article == null) {
            return false;
        }
        this.markAsRead(article);
        String url = article.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        this.app.getLuwrain().launchApp("reader", new String[]{url.trim()});
        return true;
    }

    private boolean onSummarySpace() {
        Article article = (Article)this.summaryArea.selected();
        if (article == null) {
            return false;
        }
        if (!this.markAsRead(article)) {
            return false;
        }
        this.summaryArea.refresh();
        this.groupsArea.refresh();
        int index = this.summaryArea.selectedIndex();
        if (index + 1 >= this.summaryArea.getListModel().getItemCount()) {
            this.setActiveArea((Area)this.groupsArea);
        } else {
            this.summaryArea.select(index + 1, true);
        }
        return true;
    }

    private boolean onSummaryClick(Article article) {
        DocumentBuilder docBuilder = new DocumentBuilderLoader().newDocumentBuilder(this.getLuwrain(), "text/html");
        if (docBuilder == null) {
            return false;
        }
        this.markAsRead(article);
        this.summaryArea.refresh();
        this.groupsArea.refresh();
        Properties props = new Properties();
        props.setProperty("url", article.getUrl());
        Document doc = docBuilder.buildDoc(article.getContent(), props);
        if (doc != null) {
            doc.commit();
        }
        return true;
    }

    private boolean markAsRead(Article article) {
        if (article.getStatus() == Article.Status.NEW) {
            article.setStatus(Article.Status.READ);
            this.app.persist.getArticleDAO().update(article);
        }
        return true;
    }

    boolean setShowAllGroupsMode(boolean value) {
        this.app.showAllGroups = value;
        this.groupsArea.refresh();
        this.app.getLuwrain().playSound(Sounds.OK);
        return true;
    }

    final class SummaryAppearance
    implements ListArea.Appearance<Article> {
        SummaryAppearance() {
        }

        public void announceItem(Article article, Set<ListArea.Appearance.Flags> flags) {
            String title = MainLayout.this.getLuwrain().getSpeakableText(article.getTitle(), Luwrain.SpeakableTextType.NATURAL);
            if (flags.contains(ListArea.Appearance.Flags.BRIEF)) {
                MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)title));
                return;
            }
            switch (article.getStatus()) {
                case READ: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)(((Strings)MainLayout.this.app.getStrings()).readPrefix() + " " + title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(new Date(article.getPublishedTimestamp())))));
                    break;
                }
                case MARKED: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((String)(((Strings)MainLayout.this.app.getStrings()).markedPrefix() + " " + title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(new Date(article.getPublishedTimestamp())))));
                    break;
                }
                default: {
                    MainLayout.this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)(title + " " + MainLayout.this.app.getI18n().getPastTimeBrief(new Date(article.getPublishedTimestamp())))));
                }
            }
        }

        public String getScreenAppearance(Article article, Set<ListArea.Appearance.Flags> flags) {
            switch (article.getStatus()) {
                case NEW: {
                    return " [" + article.getTitle() + "]";
                }
                case MARKED: {
                    return "* " + article.getTitle();
                }
            }
            return "  " + article.getTitle();
        }

        public int getObservableLeftBound(Article article) {
            return 2;
        }

        public int getObservableRightBound(Article article) {
            return article.getTitle().length() + 2;
        }
    }
}

