/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.mail;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.mail.App;
import org.luwrain.app.mail.Data;
import org.luwrain.app.mail.Strings;
import org.luwrain.app.mail.SummaryItem;
import org.luwrain.app.mail.layouts.AccountsLayout;
import org.luwrain.app.mail.layouts.FolderPropertiesLayout;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.TreeListArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.persistence.Folder;
import org.luwrain.pim.mail.persistence.MessageMetadata;
import org.luwrain.pim.workers.Pop3;

final class MainLayout
extends LayoutBase
implements TreeListArea.LeafClickHandler<Folder>,
ListArea.ClickHandler<SummaryItem> {
    private static final InputEvent HOT_KEY_REPLY = new InputEvent('r', EnumSet.of(InputEvent.Modifiers.ALT));
    final App app;
    final TreeListArea<Folder> foldersArea;
    final ListArea<SummaryItem> summaryArea;
    final NavigationArea messageArea;
    private final Data data;
    private final List<SummaryItem> summaryItems = new ArrayList<SummaryItem>();
    private boolean showDeleted = false;
    private Folder folder = null;
    private Message message = null;

    MainLayout(final App app, final Data data) {
        super((AppBase)app);
        this.app = app;
        this.data = data;
        Strings s = (Strings)app.getStrings();
        TreeListArea.Params treeParams = new TreeListArea.Params();
        treeParams.context = this.getControlContext();
        treeParams.name = ((Strings)app.getStrings()).foldersAreaName();
        treeParams.model = new FoldersModel();
        treeParams.leafClickHandler = this;
        this.foldersArea = new TreeListArea<Folder>(treeParams){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case PROPERTIES: {
                            return MainLayout.this.onFolderProps();
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.foldersArea.requery();
        this.summaryArea = new ListArea<SummaryItem>(this.listParams(params -> {
            params.name = ((Strings)app.getStrings()).summaryAreaName();
            params.model = new ListUtils.ListModel(this.summaryItems);
            params.clickHandler = this;
            params.appearance = new ListUtils.DoubleLevelAppearance<SummaryItem>(this.getControlContext()){

                public void announceNonSection(SummaryItem summaryItem) {
                    MainLayout.this.announceSummaryMessage(summaryItem);
                }

                public boolean isSectionItem(SummaryItem item) {
                    return item.type == SummaryItem.Type.SECTION;
                }
            };
            params.transition = new ListUtils.DoubleLevelTransition<SummaryItem>(params.model){

                public boolean isSectionItem(SummaryItem item) {
                    return item.type == SummaryItem.Type.SECTION;
                }
            };
        })){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case REFRESH: {
                            MainLayout.this.updateSummary();
                            return true;
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.messageArea = new NavigationArea(this.getControlContext()){

            public String getAreaName() {
                return ((Strings)app.getStrings()).messageAreaName();
            }

            public String getLine(int index) {
                return index < data.messageLines.size() ? data.messageLines.get(index) : "";
            }

            public int getLineCount() {
                return data.messageLines.size() >= 1 ? data.messageLines.size() : 1;
            }

            public void announceLine(int index, String line) {
                boolean attention;
                boolean bl = attention = index < data.messageAttachments.size() && data.messageAttachments.get(index) != null;
                if (line.isEmpty()) {
                    app.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
                    return;
                }
                if (attention) {
                    app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.ATTENTION, (String)MainLayout.this.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING)));
                } else {
                    app.setEventResponse(DefaultEventResponse.text((String)MainLayout.this.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING)));
                }
            }

            public boolean onInputEvent(InputEvent event) {
                if (event.isSpecial()) {
                    switch (event.getSpecial()) {
                        case BACKSPACE: {
                            MainLayout.this.setActiveArea((Area)MainLayout.this.summaryArea);
                            return true;
                        }
                    }
                }
                return super.onInputEvent(event);
            }
        };
        LayoutBase.ActionInfo fetchIncomingBkg = this.action("fetch-incoming-bkg", s.actionFetchIncomingBkg(), new InputEvent(InputEvent.Special.F6), () -> {
            this.getLuwrain().runWorker(Pop3.NAME);
            return true;
        });
        this.setAreaLayout(AreaLayout.LEFT_TOP_BOTTOM, (Area)this.foldersArea, this.actions(new LayoutBase.ActionInfo[]{this.action("remove-folder", s.actionRemoveFolder(), new InputEvent(InputEvent.Special.DELETE), this::actRemoveFolder), this.action("new-folder", s.actionNewFolder(), new InputEvent(InputEvent.Special.INSERT), this::actNewFolder), this.action("accounts", s.actionAccounts(), new InputEvent(InputEvent.Special.F11), () -> {
            app.setAreaLayout(new AccountsLayout(app, this.getReturnAction()));
            this.getLuwrain().announceActiveArea();
            return true;
        }), fetchIncomingBkg}), (Area)this.summaryArea, this.actions(new LayoutBase.ActionInfo[]{this.action("reply", ((Strings)app.getStrings()).actionReply(), HOT_KEY_REPLY, this::actSummaryReply), this.action("mark", ((Strings)app.getStrings()).actionMarkMessage(), new InputEvent(InputEvent.Special.INSERT), this::actMarkMessage, () -> {
            SummaryItem item = (SummaryItem)this.summaryArea.selected();
            return item != null && item.message != null && item.message.getMetadata().getState() != MessageMetadata.State.MARKED;
        }), this.action("unmark", ((Strings)app.getStrings()).actionUnmarkMessage(), new InputEvent(InputEvent.Special.INSERT), this::actUnmarkMessage, () -> {
            SummaryItem item = (SummaryItem)this.summaryArea.selected();
            return item != null && item.message != null && item.message.getMetadata().getState() == MessageMetadata.State.MARKED;
        }), this.action("delete", ((Strings)app.getStrings()).actionDeleteMessage(), new InputEvent(InputEvent.Special.DELETE), this::actDeleteMessage), this.action("delete-forever", ((Strings)app.getStrings()).actionDeleteMessageForever(), new InputEvent(InputEvent.Special.DELETE, EnumSet.of(InputEvent.Modifiers.CONTROL)), this::actDeleteMessageForever), this.action("deleted-show", ((Strings)app.getStrings()).actionDeletedShow(), new InputEvent('='), () -> {
            this.showDeleted = true;
            this.updateSummary();
            this.getLuwrain().playSound(Sounds.OK);
            return true;
        }), this.action("deleted-hide", ((Strings)app.getStrings()).actionDeletedHide(), new InputEvent('-'), () -> {
            this.showDeleted = false;
            this.updateSummary();
            this.getLuwrain().playSound(Sounds.OK);
            return true;
        }), fetchIncomingBkg}), (Area)this.messageArea, this.actions(new LayoutBase.ActionInfo[]{fetchIncomingBkg}));
    }

    void updateSummary() {
        this.summaryItems.clear();
        List<Message> m = this.data.getMessagesInLocalFolder(this.folder.getId());
        if (!this.showDeleted) {
            // empty if block
        }
        this.summaryItems.addAll(this.app.getHooks().organizeSummary(m));
        this.summaryArea.refresh();
    }

    public boolean onLeafClick(TreeListArea<Folder> area, Folder folder) {
        this.folder = folder;
        this.updateSummary();
        this.summaryArea.reset(false);
        this.setActiveArea((Area)this.summaryArea);
        return true;
    }

    private boolean actNewFolder() {
        Folder opened = (Folder)this.foldersArea.opened();
        if (opened == null) {
            return false;
        }
        String name = this.app.getConv().newFolderName();
        if (name == null) {
            return true;
        }
        int selectedIndex = this.foldersArea.selectedIndex();
        Folder newFolder = new Folder();
        newFolder.setName(name);
        newFolder.setParentFolderId(opened.getId());
        this.data.folderDAO.add(newFolder);
        this.foldersArea.requery();
        this.foldersArea.refresh();
        return true;
    }

    private boolean actRemoveFolder() {
        Folder opened = (Folder)this.foldersArea.opened();
        if (opened == null) {
            return false;
        }
        int selectedIndex = this.foldersArea.selectedIndex();
        if (selectedIndex < 0) {
            return false;
        }
        if (!this.app.getConv().removeFolder()) {
            return true;
        }
        this.foldersArea.requery();
        this.foldersArea.refresh();
        return true;
    }

    private boolean onFolderProps() {
        Folder folder = (Folder)this.foldersArea.selected();
        if (folder == null) {
            return false;
        }
        FolderPropertiesLayout propsLayout = new FolderPropertiesLayout(this.app, folder, () -> {
            this.app.setAreaLayout(this);
            this.foldersArea.refresh();
            this.app.getLuwrain().announceActiveArea();
            return true;
        });
        this.app.setAreaLayout(propsLayout);
        this.app.getLuwrain().announceActiveArea();
        return true;
    }

    public boolean onListClick(ListArea area, int index, SummaryItem item) {
        Message message = item.message;
        if (message == null) {
            return false;
        }
        if (message.getMetadata().getState() == MessageMetadata.State.NEW) {
            message.getMetadata().setState(MessageMetadata.State.READ);
            this.data.messageDAO.update(message.getMetadata());
            this.summaryArea.refresh();
        }
        this.data.setMessage(message);
        this.messageArea.redraw();
        this.messageArea.setHotPoint(0, 0);
        this.setActiveArea((Area)this.messageArea);
        return true;
    }

    private boolean actMarkMessage() {
        SummaryItem item = (SummaryItem)this.summaryArea.selected();
        if (item == null || item.message == null) {
            return false;
        }
        item.message.getMetadata().setState(MessageMetadata.State.MARKED);
        this.data.messageDAO.update(item.message.getMetadata());
        this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.SELECTED, (String)((Strings)this.app.getStrings()).messageMarked()));
        return true;
    }

    private boolean actUnmarkMessage() {
        SummaryItem item = (SummaryItem)this.summaryArea.selected();
        if (item == null || item.message == null) {
            return false;
        }
        item.message.getMetadata().setState(MessageMetadata.State.READ);
        this.data.messageDAO.update(item.message.getMetadata());
        this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.SELECTED, (String)((Strings)this.app.getStrings()).messageUnmarked()));
        return true;
    }

    private boolean actSummaryReply() {
        SummaryItem item = (SummaryItem)this.summaryArea.selected();
        if (item == null || item.message == null) {
            return false;
        }
        this.app.getHooks().makeReply(item.message);
        return true;
    }

    private boolean actDeleteMessage() {
        SummaryItem item = (SummaryItem)this.summaryArea.selected();
        if (item == null || item.message == null) {
            return false;
        }
        item.message.getMetadata().setState(MessageMetadata.State.DELETED);
        this.data.messageDAO.update(item.message.getMetadata());
        this.summaryItems.remove(item);
        this.summaryArea.refresh();
        SummaryItem newSelected = (SummaryItem)this.summaryArea.selected();
        if (newSelected != null) {
            this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.OK, (String)newSelected.title));
        } else {
            this.app.setEventResponse(DefaultEventResponse.hint((Hint)Hint.NO_ITEMS_BELOW));
        }
        return true;
    }

    private boolean actDeleteMessageForever() {
        SummaryItem item = (SummaryItem)this.summaryArea.selected();
        if (item == null || item.message == null) {
            return false;
        }
        if (!this.app.getConv().deleteMessageForever()) {
            return true;
        }
        this.data.messageDAO.delete(item.message.getMetadata());
        this.updateSummary();
        return true;
    }

    private void announceSummaryMessage(SummaryItem summaryItem) {
        String announcement;
        Message m = summaryItem.message;
        if (m == null) {
            return;
        }
        String string = announcement = m.getMetadata().getTitle() != null && !m.getMetadata().getTitle().isEmpty() ? m.getMetadata().getTitle().trim() : m.getMetadata().getFromAddr();
        if (m.getMetadata().getState() == null) {
            this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)announcement, (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
            return;
        }
        switch (m.getMetadata().getState()) {
            case NEW: {
                this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.ATTENTION, (String)announcement, (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
                break;
            }
            case READ: {
                this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)announcement, (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
                break;
            }
            case MARKED: {
                this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.SELECTED, (String)announcement, (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
                break;
            }
            default: {
                this.app.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)announcement, (Suggestions)Suggestions.CLICKABLE_LIST_ITEM));
            }
        }
    }

    boolean saveAttachment(String fileName) {
        return true;
    }

    final class FoldersModel
    implements TreeListArea.Model<Folder> {
        FoldersModel() {
        }

        public boolean getItems(Folder folder, TreeListArea.Collector<Folder> collector) {
            collector.collect(MainLayout.this.data.folderDAO.getChildFolders(folder));
            return true;
        }

        public Folder getRoot() {
            return MainLayout.this.data.folderDAO.getRoot();
        }

        public boolean isLeaf(Folder folder) {
            return MainLayout.this.data.folderDAO.getChildFolders(folder).size() == 0;
        }
    }
}

