/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.mail.layouts;

import java.util.Objects;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.mail.App;
import org.luwrain.app.mail.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.mail.persistence.Account;

final class SmtpAccountLayout
extends LayoutBase {
    private static final String NAME = "name";
    private static final String HOST = "host";
    private static final String PASSWD = "passwd";
    private static final String PORT = "port";
    private static final String TLS = "tls";
    private static final String DEFAULT = "default";
    private static final String ENABLED = "enabled";
    private final App app;
    final FormArea formArea;

    public SmtpAccountLayout(App app, Account account, LayoutBase.ActionHandler closing) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.formArea = new FormArea(this.getControlContext(), s.pop3AccountAreaName(account.getName()));
        this.formArea.addEdit(NAME, s.accountPropertiesName(), Objects.requireNonNullElse(account.getName(), "").trim());
        this.formArea.addEdit(HOST, s.accountPropertiesHost(), Objects.requireNonNullElse(account.getHost(), "").trim());
        this.formArea.addEdit(PORT, s.accountPropertiesPort(), String.valueOf(account.getPort()));
        this.formArea.addPasswd(PASSWD, s.accountPropertiesPasswd(), Objects.requireNonNullElse(account.getPasswd(), ""), null, true);
        this.formArea.addCheckbox(TLS, s.accountPropertiesTls(), account.isTls());
        this.formArea.addCheckbox(DEFAULT, s.accountPropertiesDefault(), account.isDefaultAccount());
        this.formArea.addCheckbox(ENABLED, s.accountPropertiesEnabled(), account.isEnabled());
        this.setCloseHandler(closing);
        this.setOkHandler(() -> {
            if (!this.save(account)) {
                return true;
            }
            return closing.onAction();
        });
        this.setAreaLayout((Area)this.formArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private boolean save(Account account) {
        int portValue;
        String name = this.formArea.getEnteredText(NAME).trim();
        String host = this.formArea.getEnteredText(HOST).trim();
        String passwd = this.formArea.getEnteredText(PASSWD);
        String port = this.formArea.getEnteredText(PORT).trim();
        if (name.isEmpty()) {
            this.getLuwrain().message(((Strings)this.app.getStrings()).accountPropertiesNameCannotBeEmpty(), Luwrain.MessageType.ERROR);
            return false;
        }
        try {
            portValue = Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            this.getLuwrain().message(((Strings)this.app.getStrings()).accountPropertiesInvalidPortValue(), Luwrain.MessageType.ERROR);
            return false;
        }
        if (portValue <= 0 || portValue > 65536) {
            this.getLuwrain().message(((Strings)this.app.getStrings()).accountPropertiesInvalidPortValue(), Luwrain.MessageType.ERROR);
            return false;
        }
        account.setName(name);
        account.setHost(host);
        account.setPort(portValue);
        account.setPasswd(passwd);
        account.setTls(this.formArea.getCheckboxState(TLS));
        account.setDefaultAccount(this.formArea.getCheckboxState(DEFAULT));
        account.setEnabled(this.formArea.getCheckboxState(ENABLED));
        this.app.getData().accountDAO.update(account);
        return true;
    }
}

