/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.ru;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.luwrain.core.NullCheck;
import org.luwrain.nlp.POS;
import org.luwrain.nlp.Word;
import org.luwrain.nlp.ru.GramAttr;

public final class RuWord
implements Word {
    @SerializedName(value="pos")
    private POS pos = null;
    @SerializedName(value="lemma")
    private String lemma = null;
    @SerializedName(value="gram")
    private String gramBaseStr = null;
    @SerializedName(value="forms")
    private List<Form> forms = null;
    private transient GramAttr gramBase = null;

    public void init() {
        if (this.lemma != null) {
            this.lemma = this.lemma.toUpperCase();
        }
        this.gramBase = this.gramBaseStr != null ? GramAttr.fromString((String)this.gramBaseStr) : new GramAttr(null, null, null);
        if (this.forms != null) {
            for (Form f : this.forms) {
                f.init(this.gramBase);
            }
        }
    }

    public POS getPos() {
        return this.pos;
    }

    public String getLemma() {
        return this.lemma != null ? this.lemma : "";
    }

    public GramAttr getGram() {
        return this.gramBase;
    }

    public Form[] getForms() {
        if (this.forms == null) {
            return new Form[0];
        }
        return this.forms.toArray(new Form[this.forms.size()]);
    }

    public static final class Form {
        @SerializedName(value="gram")
        private String gramStr = null;
        @SerializedName(value="word")
        private String word = null;
        private transient GramAttr gram = null;

        void init(GramAttr gramBase) {
            NullCheck.notNull((Object)gramBase, (String)"gramBase");
            if (this.word != null) {
                this.word = this.word.toUpperCase();
            }
            this.gram = this.gramStr != null ? new GramAttr(gramBase, GramAttr.fromString((String)this.gramStr)) : gramBase;
        }

        public GramAttr getGram() {
            return this.gram;
        }

        public String getWord() {
            return this.word;
        }
    }
}

