/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail.script;

import java.util.Objects;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.Luwrain;
import org.luwrain.pim.PimException;
import org.luwrain.pim.mail.persistence.FolderDAO;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.MessageDAO;
import org.luwrain.pim.mail.script.FoldersObj;
import org.luwrain.script.ScriptUtils;

public final class MailObj {
    static final Session session = Session.getDefaultInstance((Properties)new Properties(), null);
    static final Logger log = LogManager.getLogger();
    final FolderDAO folderDAO;
    final MessageDAO messageDAO;
    @HostAccess.Export
    public final ProxyExecutable getFolders = this::getFoldersImpl;
    @HostAccess.Export
    public final ProxyExecutable getAddressPersonalName = this::getAddressPersonalNameImpl;
    @HostAccess.Export
    public final ProxyExecutable getAddressWithoutPersonalName = this::getAddressWithoutPersonalNameImpl;

    public MailObj(Luwrain luwrain) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        MailPersistence persist = (MailPersistence)luwrain.createInstance(MailPersistence.class);
        this.folderDAO = persist.getFolderDAO();
        this.messageDAO = persist.getMessageDAO();
    }

    private Object getFoldersImpl(Value[] args) {
        return new FoldersObj(this);
    }

    private Object getAddressPersonalNameImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1) || !args[0].isString() || args[0].asString().trim().isEmpty()) {
            throw new IllegalArgumentException("Mail.getAddressPersonalName() takes exactly one non-empty string argument");
        }
        try {
            InternetAddress inetAddr = new InternetAddress(args[0].asString().trim(), false);
            String personal = inetAddr.getPersonal();
            return personal != null ? personal.trim() : "";
        }
        catch (AddressException ex) {
            throw new PimException(ex);
        }
    }

    private Object getAddressWithoutPersonalNameImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen((Value[])args, (int)1) || !args[0].isString()) {
            throw new IllegalArgumentException("Mail.getAddressWithoutPersonalName() takes exactly one string argument");
        }
        try {
            InternetAddress inetAddr = new InternetAddress(args[0].asString().trim(), false);
            String personal = inetAddr.getAddress();
            return personal != null ? personal.trim() : "";
        }
        catch (AddressException ex) {
            throw new PimException(ex);
        }
    }
}

