/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.File;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.reader.App;
import org.luwrain.app.reader.Strings;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.io.api.books.v1.Book;

final class LocalRepoLayout
extends LayoutBase
implements ListArea.ClickHandler {
    final App app;
    final ListArea listArea;

    LocalRepoLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.listArea = new ListArea(this.createListParams()){
            final LayoutBase.Actions actions;
            {
                super(params);
                this.actions = LocalRepoLayout.this.actions(new LayoutBase.ActionInfo[]{LocalRepoLayout.this.action("delete", ((Strings)app.getStrings()).localRepoActDelete(), new InputEvent(InputEvent.Special.DELETE), LocalRepoLayout.this::actDelete)});
            }

            public boolean onInputEvent(InputEvent event) {
                if (app.onInputEvent((Area)this, event)) {
                    return true;
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                if (app.onSystemEvent((Area)this, event, this.actions)) {
                    return true;
                }
                return super.onSystemEvent(event);
            }

            public boolean onAreaQuery(AreaQuery query) {
                NullCheck.notNull((Object)query, (String)"query");
                if (app.onAreaQuery((Area)this, query)) {
                    return true;
                }
                return super.onAreaQuery(query);
            }

            public Action[] getAreaActions() {
                return this.actions.getAreaActions();
            }
        };
        this.setAreaLayout((Area)this.listArea, null);
    }

    public boolean onListClick(ListArea listArea, int index, Object obj) {
        if (!(obj instanceof Book)) {
            return false;
        }
        Book book = (Book)obj;
        if (!this.app.getLocalRepo().hasBook(book)) {
            this.app.message(((Strings)this.app.getStrings()).localRepoBookCorrupted(), Luwrain.MessageType.ERROR);
            return true;
        }
        File mainFile = this.app.getLocalRepo().findDaisyMainFile(book);
        if (mainFile == null) {
            this.app.message(((Strings)this.app.getStrings()).localRepoBookCorrupted(), Luwrain.MessageType.ERROR);
            return true;
        }
        this.app.open(mainFile.toURI());
        return true;
    }

    private boolean actDelete() {
        Object obj = this.listArea.selected();
        if (obj == null || !(obj instanceof Book)) {
            return false;
        }
        Book book = (Book)obj;
        if (!this.app.getConv().confirmLocalBookDeleting(book.getName())) {
            return true;
        }
        this.app.getLocalRepo().remove(book);
        this.listArea.refresh();
        return true;
    }

    private ListArea.Params createListParams() {
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(this.app.getLuwrain());
        params.name = ((Strings)this.app.getStrings()).localRepoAreaName();
        params.model = new ListUtils.ArrayModel(() -> this.app.getLocalRepo().getBooks());
        params.appearance = new ListUtils.DefaultAppearance(params.context);
        params.clickHandler = this;
        return params;
    }
}

