/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.controls.reader.view.RowPart;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Run;

final class RowPartsSplitter {
    private static final String LOG_COMPONENT = "doctree";
    final List<RowPart> res = new ArrayList<RowPart>();
    private int index = 0;
    private int offset = 0;

    RowPartsSplitter() {
    }

    void onRun(Run run, String text, int boundFrom, int boundTo, int maxRowLen) {
        NullCheck.notNull((Object)run, (String)"run");
        NullCheck.notNull((Object)text, (String)"text");
        if (boundFrom < 0 || boundTo < 0) {
            throw new IllegalArgumentException("boundFrom (" + boundFrom + ") and boundTo (" + boundTo + ") may not be negative");
        }
        if (boundFrom > text.length() || boundTo > text.length()) {
            throw new IllegalArgumentException("boundFrom (" + boundFrom + ") and boundTo (" + boundTo + ") may not be greater than length of the text (" + text.length() + ")");
        }
        if (boundFrom > boundTo) {
            throw new IllegalArgumentException("boundFrom (" + boundFrom + ") may not be greater than boundTo (" + boundTo + ")");
        }
        if (this.offset > maxRowLen) {
            throw new RuntimeException("offset (" + this.offset + ") may not be greater than maxRowLen (" + maxRowLen + ")");
        }
        if (boundFrom == boundTo) {
            return;
        }
        int nextStepFrom = boundFrom;
        while (nextStepFrom < boundTo) {
            int stepFrom = nextStepFrom;
            int roomOnLine = maxRowLen - this.offset;
            if (roomOnLine == 0) {
                ++this.index;
                this.offset = 0;
                continue;
            }
            int remains = boundTo - stepFrom;
            if (remains <= roomOnLine) {
                this.res.add(this.makeTextPart(run, stepFrom, boundTo));
                this.offset += remains;
                return;
            }
            int stepTo = this.findWordsFittingOnLIne(text, stepFrom, boundTo, roomOnLine);
            if (stepTo == stepFrom) {
                if (this.offset > 0) {
                    this.offset = 0;
                    ++this.index;
                    continue;
                }
                stepTo = stepFrom + roomOnLine;
            }
            if (stepTo <= stepFrom) {
                throw new RuntimeException("stepTo (" + stepTo + ") == stepFrom (" + stepFrom + ")");
            }
            if (stepTo - stepFrom > roomOnLine) {
                throw new RuntimeException("Exceeding room on line (" + roomOnLine + "), stepFrom=" + stepFrom + ", stepTo=" + stepTo);
            }
            this.res.add(this.makeTextPart(run, stepFrom, stepTo));
            ++this.index;
            this.offset = 0;
            nextStepFrom = this.findNextWord(stepTo, text, boundTo);
        }
    }

    private int findWordsFittingOnLIne(String text, int posFrom, int boundTo, int lenRestriction) {
        int pos = 0;
        int nextWordEnd = posFrom;
        while (nextWordEnd - posFrom <= lenRestriction) {
            pos = nextWordEnd;
            while (nextWordEnd < boundTo && Character.isSpace(text.charAt(nextWordEnd))) {
                ++nextWordEnd;
            }
            while (nextWordEnd < boundTo && !Character.isSpace(text.charAt(nextWordEnd))) {
                ++nextWordEnd;
            }
            if (nextWordEnd != pos) continue;
            return pos;
        }
        return pos;
    }

    private int findNextWord(int pos, String text, int boundTo) {
        int i;
        NullCheck.notNull((Object)text, (String)"text");
        for (i = pos; i < boundTo && Character.isSpace(text.charAt(i)); ++i) {
        }
        if (i >= boundTo) {
            return pos;
        }
        return i;
    }

    private RowPart makeTextPart(Run run, int posFrom, int posTo) {
        NullCheck.notNull((Object)run, (String)"run");
        return new RowPart(run, posFrom, posTo, this.index);
    }
}

