/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;

public class Table
extends Node {
    Table() {
        super(Node.Type.TABLE);
    }

    @Override
    void preprocess() {
        NullCheck.notNullItems((Object[])this.subnodes, (String)"subnodes");
        for (int i = 0; i < this.subnodes.length; ++i) {
            if (this.subnodes[i] instanceof TableRow) continue;
            Log.warning((String)"doctree", (String)("table has a subnode of class " + this.subnodes[i].getClass().getName() + ", it will be put into newly created table row"));
            TableRow n = new TableRow();
            n.subnodes = new Node[]{this.subnodes[i]};
            n.subnodes[0].setParentNode(n);
            n.setParentNode(this);
            this.subnodes[i] = n;
        }
        int maxCellCount = 0;
        for (Node n : this.subnodes) {
            if (maxCellCount >= n.getSubnodeCount()) continue;
            maxCellCount = n.getSubnodeCount();
        }
        for (Node n : this.subnodes) {
            ((TableRow)n).addEmptyCells(maxCellCount);
        }
        super.preprocess();
    }

    public TableCell getCell(int col, int row) {
        if (row >= this.subnodes.length || col >= this.subnodes[row].subnodes.length) {
            return null;
        }
        Node cellNode = this.subnodes[row].subnodes[col];
        if (cellNode == null || !(cellNode instanceof TableCell)) {
            return null;
        }
        return (TableCell)cellNode;
    }

    public int getRowCount() {
        return this.subnodes.length;
    }

    public int getColCount() {
        int maxValue = 0;
        for (Node n : this.subnodes) {
            if (maxValue >= n.subnodes.length) continue;
            maxValue = n.subnodes.length;
        }
        return maxValue;
    }

    public int getTableLevel() {
        int count = 1;
        for (Node n = this.getParentNode(); n != null; n = n.getParentNode()) {
            if (n.type != Node.Type.TABLE) continue;
            ++count;
        }
        return count;
    }

    public boolean isSingleCellTable() {
        NullCheck.notNullItems((Object[])this.subnodes, (String)"subnodes");
        return this.subnodes.length == 1 || this.subnodes[0].getSubnodes().length == 1;
    }
}

